% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/fetch.r
\docType{methods}
\name{fetch_heads}
\alias{fetch_heads}
\alias{fetch_heads,git_repository-method}
\title{Get updated heads during the last fetch.}
\usage{
fetch_heads(repo)

\S4method{fetch_heads}{git_repository}(repo)
}
\arguments{
\item{repo}{the repository}
}
\value{
list with the S4 class \code{\linkS4class{git_fetch_head}}
entries. NULL if there is no FETCH_HEAD file.
}
\description{
Get updated heads during the last fetch.
}
\examples{
\dontrun{
## Initialize three temporary repositories
path_bare <- tempfile(pattern="git2r-")
path_repo_1 <- tempfile(pattern="git2r-")
path_repo_2 <- tempfile(pattern="git2r-")

dir.create(path_bare)
dir.create(path_repo_1)
dir.create(path_repo_2)

bare_repo <- init(path_bare, bare = TRUE)
repo_1 <- clone(path_bare, path_repo_1)
repo_2 <- clone(path_bare, path_repo_2)

config(repo_1, user.name="Alice", user.email="alice@example.org")
config(repo_2, user.name="Bob", user.email="bob@example.org")

## Add changes to repo 1
writeLines("Lorem ipsum dolor sit amet",
           con = file.path(path_repo_1, "example.txt"))
add(repo_1, "example.txt")
commit(repo_1, "Commit message")

## Push changes from repo 1 to origin (bare_repo)
push(repo_1, "origin", "refs/heads/master")

## Fetch changes from origin (bare_repo) to repo 2
fetch(repo_2, "origin")

## List updated heads
fetch_heads(repo_2)
}
}
\keyword{methods}

