% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/comments.R
\name{get_comments}
\alias{comment_commit}
\alias{comment_issue}
\alias{edit_comment}
\alias{edit_commit_comment}
\alias{edit_issue_comment}
\alias{get_comments}
\alias{get_commit_comments}
\alias{get_issue_comments}
\title{Get the comments of a commit or issue}
\usage{
get_comments(object_type = "issue", id, note_id = c(), project, ...)

get_issue_comments(...)

get_commit_comments(...)

comment_commit(project, id, text, ...)

comment_issue(project, id, text, ...)

edit_comment(object_type, text, ...)

edit_issue_comment(...)

edit_commit_comment(...)
}
\arguments{
\item{object_type}{one of "issue" or "commit". Snippets and merge_requests are not implemented yet.}

\item{id}{id of object: (project-wide) issue_id or commit sha}

\item{note_id}{id of note}

\item{project}{project name or id}

\item{...}{passed on to \code{\link{gitlab}} API call. See Details.}

\item{text}{Text of comment/note to add or edit (translates to gitlab API note/body respectively)}
}
\description{
Get the comments of a commit or issue
}
\details{
For \code{comment_commit} ... might also contain \code{path}, \code{line}
and \code{line_type} (old or new) to attach the comment to a specific in a file.
See http://doc.gitlab.com/ce/api/commits.html
}

