% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwfit.R
\name{plot.gkwfit}
\alias{plot.gkwfit}
\title{Plot Diagnostics for a gkwfit Object}
\usage{
\method{plot}{gkwfit}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"gkwfit"}, typically the result of a call to \code{\link{gkwfit}}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Invisibly returns the original input object \code{x}. This function is called for its side effect of producing a plot.
}
\description{
Creates a panel of diagnostic plots for assessing the fit of a model estimated
by \code{\link{gkwfit}}. It displays a histogram of the data overlaid with the
fitted density, a Probability-Probability (P-P) plot, a Quantile-Quantile (Q-Q)
plot, and profile likelihood plots for each parameter if they were computed
during the fit (i.e., if \code{profile = TRUE} was used in \code{\link{gkwfit}}).
}
\details{
This function utilizes \code{ggplot2} for creating the plots and \code{patchwork}
for arranging them into a single figure. All plots use \code{ggplot2::theme_minimal()}.

If the plots were already generated during the original \code{\link{gkwfit}} call
(because \code{plot = TRUE}), they are retrieved from the fitted object.
Otherwise, this function will attempt to generate the plots on the fly,
which requires the \code{ggplot2} package and the necessary distribution
functions (like \code{dgkw}, \code{pgkw}, \code{qgkw}, etc.) for the specific
\code{family} to be available.

The arrangement of plots is handled automatically by \code{patchwork::wrap_plots}.
No user interaction (like menu selection) is required.
}
\examples{
\donttest{
# Load required package
library(ggplot2)

# Generate data and fit model
set.seed(2203)
y <- rbeta_(50, gamma = 2, delta = 3)
fit <- gkwfit(data = y, family = "beta", plot = FALSE)

# Generate standard diagnostic plots
plot(fit)

# Generate data and fit model with profile = TRUE
fit <- gkwfit(data = y, family = "gkw", profile = TRUE, npoints = 15)

# Standard diagnostic plots
plot(fit)
}

}
\seealso{
\code{\link{gkwfit}}, \code{\link{summary.gkwfit}}
}
\author{
Lopes, J. E.
}
\keyword{hplot}
\keyword{methods}
