% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gkwreg-methods.R
\name{print.gkwreg}
\alias{print.gkwreg}
\title{Print Method for Generalized Kumaraswamy Regression Models}
\usage{
\method{print}{gkwreg}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{An object of class \code{"gkwreg"}, typically obtained from
\code{\link{gkwreg}}.}

\item{digits}{Minimum number of significant digits to print. Default is
\code{max(3, getOption("digits") - 3)}.}

\item{...}{Additional arguments passed to or from other methods.}
}
\value{
The object \code{x}, invisibly.
}
\description{
Print method for objects of class \code{"gkwreg"}. Provides a concise summary
of the fitted model following the style of \code{\link[stats]{print.lm}}.
}
\details{
The print method provides a concise overview of the fitted model, showing:
the call, deviance residuals summary, coefficient estimates, link functions,
and basic fit statistics. For more detailed output including standard errors
and significance tests, use \code{\link{summary.gkwreg}}.
}
\examples{
\donttest{
data(GasolineYield)
fit <- gkwreg(yield ~ batch + temp, data = GasolineYield, family = "kw")
print(fit)

# With more digits
print(fit, digits = 5)
}

}
\seealso{
\code{\link{gkwreg}}, \code{\link{summary.gkwreg}}
}
\author{
Lopes, J. E.
}
