% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6covariance.R
\name{Covariance}
\alias{Covariance}
\title{R6 Class representing a covariance function and data}
\description{
R6 Class representing a covariance function and data

R6 Class representing a covariance function and data
}
\details{
For the generalised linear mixed model 

\deqn{Y \sim F(\mu,\sigma)}
\deqn{\mu = h^-1(X\beta + Z\gamma)}
\deqn{\gamma \sim MVN(0,D)}

where h is the link function, this class defines Z and D. The covariance is defined by a covariance function, data, and parameters.
A new instance can be generated with $new(). The class will generate the 
relevant matrices Z and D automatically. See \href{https://github.com/samuel-watson/glmmrBase/blob/master/README.md}{glmmrBase} for a 
detailed guide on model specification.


**Intitialisation**
A covariance function is specified as an additive formula made up of 
components with structure \code{(1|f(j))}. The left side of the vertical bar 
specifies the covariates in the model that have a random effects structure. 
The right side of the vertical bar specify the covariance function `f` for 
that term using variable named in the data `j`. 
Covariance functions on the right side of the vertical bar are multiplied 
together, i.e. \code{(1|f(j)*g(t))}. 

There are several common functions included for a named variable in data \code{x}.
A non-exhaustive list (see \href{https://github.com/samuel-watson/glmmrBase/blob/master/README.md}{glmmrBase} for a full list):
* \code{gr(x)}: Indicator function (1 parameter)   
* \code{fexp(x)}: Exponential function (2 parameters)
* \code{ar1(x)}: AR1 function (1 parameter)
* \code{sqexp(x)}: Squared exponential (1 parameter)
* \code{matern(x)}: Matern function (2 parameters)
* \code{bessel(x)}: Modified Bessel function of the 2nd kind (1 parameter)

Parameters are provided to the covariance function as a vector. 
The parameters in the vector for each function should be provided 
in the order the covariance functions are written are written. 
For example,
* Formula: `~(1|gr(j))+(1|gr(j*t))`; parameters: `c(0.25,0.1)`
* Formula: `~(1|gr(j)*fexp(t))`; parameters: `c(0.25,1,0.5)`
Note that it is also possible to specify a group membership with two
variable alternatively as `(1|gr(j)*gr(t))`, for example, but this 
will require two parameters to be specified, so it is recommended against.
}
\examples{

## ------------------------------------------------
## Method `Covariance$new`
## ------------------------------------------------

df <- nelder(~(cl(5)*t(5)) > ind(5))
cov <- Covariance$new(formula = ~(1|gr(cl)*ar1(t)),
                      parameters = c(0.25,0.7),
                      data= df)

## ------------------------------------------------
## Method `Covariance$check`
## ------------------------------------------------

df <- nelder(~(cl(5)*t(5)) > ind(5))
cov <- Covariance$new(formula = ~(1|gr(cl)*ar1(t)),
                      parameters = c(0.15,0.8),
                      data= df)
cov$parameters <- c(0.25,0.1)
cov$check(verbose=FALSE)

## ------------------------------------------------
## Method `Covariance$print`
## ------------------------------------------------

df <- nelder(~(cl(5)*t(5)) > ind(5))
Covariance$new(formula = ~(1|gr(cl)*ar1(t)),
                      parameters = c(0.05,0.8),
                      data= df)

## ------------------------------------------------
## Method `Covariance$subset`
## ------------------------------------------------

df <- nelder(~(cl(10)*t(5)) > ind(10))
cov <- Covariance$new(formula = ~(1|gr(cl)*ar1(t)),
                      parameters = c(0.05,0.8),
                      data= df)
cov$subset(1:100)                     

## ------------------------------------------------
## Method `Covariance$sampleD`
## ------------------------------------------------

df <- nelder(~(cl(10)*t(5)) > ind(10))
cov <- Covariance$new(formula = ~(1|gr(cl)*ar1(t)),
                      parameters = c(0.05,0.8),
                      data= df)
cov$sampleD(c(0.01,0.1))
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{data}}{Data frame with data required to build covariance}

\item{\code{formula}}{Covariance function formula.}

\item{\code{parameters}}{Model parameters specified in order of the functions in the formula.}

\item{\code{eff_range}}{The effective range of covariance functions, specified in order of the functions in the formula. Only 
the functions with compact support require effective range parameters.}

\item{\code{Z}}{Design matrix}

\item{\code{D}}{Covariance matrix of the random effects}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Covariance-n}{\code{Covariance$n()}}
\item \href{#method-Covariance-new}{\code{Covariance$new()}}
\item \href{#method-Covariance-check}{\code{Covariance$check()}}
\item \href{#method-Covariance-print}{\code{Covariance$print()}}
\item \href{#method-Covariance-subset}{\code{Covariance$subset()}}
\item \href{#method-Covariance-sampleD}{\code{Covariance$sampleD()}}
\item \href{#method-Covariance-get_D_data}{\code{Covariance$get_D_data()}}
\item \href{#method-Covariance-get_chol_D}{\code{Covariance$get_chol_D()}}
\item \href{#method-Covariance-clone}{\code{Covariance$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-n"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-n}{}}}
\subsection{Method \code{n()}}{
Return the size of the design
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$n()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Scalar
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-new"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-new}{}}}
\subsection{Method \code{new()}}{
Create a new Covariance object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$new(
  formula = NULL,
  data = NULL,
  parameters = NULL,
  eff_range = NULL,
  verbose = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{formula}}{Formula describing the covariance function. See Details}

\item{\code{data}}{Data frame with data required for constructing the covariance.}

\item{\code{parameters}}{Vector with parameter values for the functions in the model
formula. See Details.}

\item{\code{eff_range}}{(Optional) Vector with the effective range parameter for covariance
functions that require it, i.e. those with compact support.}

\item{\code{verbose}}{Logical whether to provide detailed output.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Covariance object
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- nelder(~(cl(5)*t(5)) > ind(5))
cov <- Covariance$new(formula = ~(1|gr(cl)*ar1(t)),
                      parameters = c(0.25,0.7),
                      data= df)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-check"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-check}{}}}
\subsection{Method \code{check()}}{
Check if anything has changed and update matrices if so.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$check(verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{Logical whether to report if any changes detected.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- nelder(~(cl(5)*t(5)) > ind(5))
cov <- Covariance$new(formula = ~(1|gr(cl)*ar1(t)),
                      parameters = c(0.15,0.8),
                      data= df)
cov$parameters <- c(0.25,0.1)
cov$check(verbose=FALSE)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-print"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-print}{}}}
\subsection{Method \code{print()}}{
Show details of Covariance object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$print()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- nelder(~(cl(5)*t(5)) > ind(5))
Covariance$new(formula = ~(1|gr(cl)*ar1(t)),
                      parameters = c(0.05,0.8),
                      data= df)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-subset"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-subset}{}}}
\subsection{Method \code{subset()}}{
Keep specified indices and removes the rest
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$subset(index)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{index}}{vector of indices to keep}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- nelder(~(cl(10)*t(5)) > ind(10))
cov <- Covariance$new(formula = ~(1|gr(cl)*ar1(t)),
                      parameters = c(0.05,0.8),
                      data= df)
cov$subset(1:100)                     
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-sampleD"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-sampleD}{}}}
\subsection{Method \code{sampleD()}}{
Generate a new D matrix

D is the covariance matrix of the random effects terms in the generalised linear mixed
model. This function will return a matrix D for a given set of parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$sampleD(parameters)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parameters}}{list of lists, see `initialize()`}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
matrix
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{df <- nelder(~(cl(10)*t(5)) > ind(10))
cov <- Covariance$new(formula = ~(1|gr(cl)*ar1(t)),
                      parameters = c(0.05,0.8),
                      data= df)
cov$sampleD(c(0.01,0.1))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-get_D_data"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-get_D_data}{}}}
\subsection{Method \code{get_D_data()}}{
Returns the list specifying the covariance matrix D
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$get_D_data()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-get_chol_D"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-get_chol_D}{}}}
\subsection{Method \code{get_chol_D()}}{
Returns the Cholesky decomposition of the covariance matrix D
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$get_chol_D(parameters = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parameters}}{(Optional) Vector of parameters, if specified then the Cholesky
factor is calculated with these parameter values rather than the ones stored in the
object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of matrices
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Covariance-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Covariance-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Covariance$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
