% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mcml_simlik}
\alias{mcml_simlik}
\title{Simulated likelihood optimisation step for MCML}
\usage{
mcml_simlik(cov, data, eff_range, Z, X, y, u, family, link, start, trace)
}
\arguments{
\item{cov}{An integer matrix with columns of block identifier, dimension of block, function definition, number of variables
in the argument to the funciton, and index of the parameters, respectively. Rows are specific functions of each block.}

\item{data}{Vector of data. Created by flattening the matrices in column-major order of the data used in each block.}

\item{eff_range}{Vector of values with the effective range parameters of the covariance functions, where required.}

\item{Z}{Matrix Z of the GLMM}

\item{X}{Matrix X of the GLMM}

\item{y}{Vector of observations}

\item{u}{Matrix of samples of the random effects. Each column is a sample.}

\item{family}{Character specifying the family}

\item{link}{Character specifying the link function}

\item{start}{Vector of starting values for the optimisation}

\item{trace}{Integer indicating what to report to the console, 0= nothing, 1-3=detailed output}
}
\value{
A vector of the parameters that maximise the simulated likelihood
}
\description{
Conditional on values of the random effects terms, this function will return the maximum simulated likelihood 
parameter estimates. These functions are not intended to be used by the general user since 
the complete model fitting algorithm can be accessed through the member functions of the \link[glmmrMCML]{ModelMCML} 
class. These functions are exported for users wishing to use the modular components or each step 
separately of the MCML algorithm.
}
\examples{
\donttest{
## small example with simulated data
## create data and model object with 
## parameters to simulate data and 
## act as starting values
df <- nelder(~(j(8) * t(3)) > i(4))
des <- ModelMCML$new(
 covariance = list(
  formula =  ~(1|gr(j)*ar1(t)),
  parameters = c(0.25,0.7)
),
mean = list(
  formula = ~factor(t)-1,
  parameters = rnorm(3)
),
data=df,
family=gaussian()
)
## simulate data
y <- des$sim_data()
## get covariance definition matrix
ddata <- des$covariance$get_D_data()
## simulate some values of the random effects
## first, we need to extract the Cholesky decomposition of the covariance matrix D
L <- des$covariance$get_chol_D()
## generate samples using HMC
mat <- mcmc_sample(Z = as.matrix(des$covariance$Z),
   L = as.matrix(L),
   X = as.matrix(des$mean_function$X),
   y = as.vector(y),
   beta = des$mean_function$parameters,
   var_par = 1,
   family = des$mean_function$family[[1]],
   link = des$mean_function$family[[2]],
   warmup = 250, 
   nsamp = 250,
   lambda = 5,
   maxsteps = 100,
   trace=1,
   target_accept = 0.95)
out <- mcml_simlik(cov=ddata$cov,
   data=ddata$data,
   eff_range = rep(0,30),
   Z = as.matrix(des$covariance$Z),
   X = as.matrix(des$mean_function$X),
   y = y,
   u = mat,
   family = des$mean_function$family[[1]],
   link=des$mean_function$family[[2]],
   start = c(rep(0.01,3),0.25,0.7,1.0),
   trace=0)
}
}
