% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.cv.glmnetr_230218.R
\name{predict.glmnetr}
\alias{predict.glmnetr}
\title{Get predicteds or coefficients using a glmnetr output object}
\usage{
\method{predict}{glmnetr}(object, xs_new = NULL, lam = NULL, gam = NULL, ...)
}
\arguments{
\item{object}{A glmnetr output object}

\item{xs_new}{A desing matrix for predictions}

\item{lam}{The value for lambda for determining the lasso fit.  Required.}

\item{gam}{The value for gamma for determining the lasso fit. Required.}

\item{...}{Additional arguments passed to the predict function.}
}
\value{
Coefficients or predictions using a glmnetr output object.  When
outputting coefficients (beta), creates a list with the first element, beta_, 
including 0 and non-0 terms and the second element, beta, including only 
non 0 terms.
}
\description{
Give predicteds based upon a glmnetr() output object. Because the glmnetr() function 
has no cross validation information, lambda and gamma must be specified.  To choose 
lambda and gamma based upon cross validation one may use the cv.glmnetr() or nested.glmnetr() 
and the corresponding predict() functions.
}
\examples{
set.seed(82545037)
sim.data=glmnetr.simdata(nrows=200, ncols=100, beta=NULL)
xs=sim.data$xs 
y_=sim.data$yt
event=sim.data$event
glmnetr.fit = glmnetr( xs, NULL, y_, event, family="cox")
betas = predict(glmnetr.fit,NULL,exp(-2),0.5 )
betas$beta

}
\seealso{
\code{\link{glmnetr}} , \code{\link{cv.glmnetr}} , \code{\link{nested.glmnetr}}
}
