% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm.R
\name{dfbeta.overglm}
\alias{dfbeta.overglm}
\title{Dfbeta for Negative Binomial and Beta-binomial Models}
\usage{
\method{dfbeta}{overglm}(model, coefs, identify, ...)
}
\arguments{
\item{model}{an object of class overglm which is obtained from the fit of a negative binomial or beta-binomial model.}

\item{coefs}{an (optional) character string which (partially) match the names of some parameters in the linear predictor.}

\item{identify}{an (optional) integer indicating the number of individuals to identify on the plot of dfbeta. This is only appropriate if the argument \code{coefs} is specified.}

\item{...}{further arguments passed to or from other methods.   If \code{coefs} is specified then \code{...} may be used to include graphical parameters to customize the plot. For example,  \code{col}, \code{pch}, \code{cex}, \code{main}, \code{sub}, \code{xlab}, \code{ylab}.}
}
\value{
A matrix with so many rows as individuals in the sample and so many columns as parameters. The \eqn{i}-th row of that matrix corresponds to the difference between the estimates of the parameters using all individuals and the \emph{one-step approximation} of those estimates when the \emph{i}-th individual is excluded from the dataset.
}
\description{
Produces an approximation, better known as the \emph{one-step approximation}, of the effect on the parameter estimates of a negative binomial or beta-binomial model of deleting each individual in turn. This function also can produce a plot of those effects for a subset of the parameters in the linear predictor.
}
\details{
The \emph{one-step approximation} of the estimates of the parameters in a negative binomial or beta-binomial model when the \emph{i}-th individual is excluded from the dataset consists of the vector obtained as result of the first iteration of the Newthon-Raphson algorithm when it is performed using: (1) a dataset in which the \emph{i}-th individual is excluded; and (2) a starting value which is the estimate of the same negative binomial or beta-binomial model but based on the dataset inluding all individuals.
}
\examples{
fit <- glm(cbind(cells,200-cells) ~ tnf + ifn + tnf*ifn, family=binomial, data=cellular)
dfbs <- dfbeta(fit, coefs="tnf:ifn", col="red", lty=1, lwd=1, col.lab="blue",
               col.axis="blue", col.main="black", family="mono", cex=0.8, main="Dfbeta")
}
\references{
Pregibon D. (1981). Logistic regression diagnostics. \emph{The Annals of Statistics}, 9, 705-724.
}
