% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{rinse}
\alias{rinse}
\title{Dental Clinical Trial}
\format{
A data frame with 315 rows and 7 variables:
\describe{
  \item{subject}{a character string giving the identifier of the volunteer.}
  \item{gender}{a factor indicating the gender of the volunteer: "Female" and "Male".}
  \item{age}{a numeric vector indicating the age of the volunteer.}
  \item{rinse}{a factor indicating the type of rinse used by the volunteer: "Placebo", "A" and "B".}
  \item{smoke}{a factor indicating if the volunteer smoke: "Yes" and "No".}
  \item{time}{a numeric vector indicating the time (in months) since the treatment began.}
  \item{score}{a numeric vector giving the subject’s score of plaque.}
}
}
\usage{
data(rinse)
}
\description{
These data arose from a study in dentistry. In this trial,
subjects were generally healthy adult male and female volunteers, ages
18–55, with pre-existing plaque but without advanced periodontal
disease. Prior to entry, subjects were screened for a minimum of 20
sound, natural teeth and a minimum mean plaque index of 2.0. Subjects
with gross oral pathology or on antibiotic, antibacterial, or
anti-inflammatory therapy were excluded from the study. One hundred
nine volunteers were randomized in a double-blinded way to one of two
novel mouth rinses (A and B) or to a control mouth rinse. Plaque was
scored at baseline, at 3 months, and at 6 months by the Turesky
modification of the Quigley-Hein index, a continuous measure. Four
subjects had missing plaque scores. The main objective of the
analysis is to measure the effectiveness of three mouth rinses at
inhibiting dental plaque.
}
\examples{
data(rinse)
dev.new()
boxplot(score ~ time, data=subset(rinse,rinse=="Placebo"),ylim=c(0,3.5),
        at=c(1:3)-0.2, col="yellow", xaxt="n", boxwex=0.15)
boxplot(score ~ time, data=subset(rinse,rinse=="A"), add=TRUE,
        at=c(1:3), col="gray", xaxt="n", boxwex=0.15)
boxplot(score ~ time, data=subset(rinse,rinse=="B"), add=TRUE,
        at=c(1:3) + 0.2, col="blue", xaxt="n", boxwex=0.15)
axis(1, at=c(1:3), labels=unique(rinse$time))
legend("bottomleft",legend=c("placebo","rinse A","rinse B"),
       title="Treatment",fill=c("yellow","gray","blue"),bty="n")
}
\references{
Hadgu A., Koch G. (1999) Application of generalized estimating equations
to a dental randomized clinical trial. \emph{Journal of Biopharmaceutical Statistics} 9:161-178.
}
\keyword{datasets}
