% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geeglm.R
\name{estequa.glmgee}
\alias{estequa.glmgee}
\title{Estimating Equations in Generalized Estimating Equations}
\usage{
\method{estequa}{glmgee}(model, ...)
}
\arguments{
\item{model}{an object of class glmgee which is obtained from the fit of a generalized estimating equation.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A vector with the value of the estimating equations evaluated at the parameter estimates and the observed data.
}
\description{
Extracts estimating equations evaluated at the parameter estimates and the observed data for a generalized estimating equation fitted to the data.
}
\examples{
mod <- size ~ poly(days,4) + treat
fit <- glmgee(mod, id=tree, family=Gamma("log"), data=spruces, corstr="AR-1")
estequa(fit)
}
