% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glms.R
\name{adjR2.lm}
\alias{adjR2.lm}
\title{Adjusted R-squared in Normal Linear Models}
\usage{
\method{adjR2}{lm}(..., digits = 4, verbose = TRUE)
}
\arguments{
\item{...}{one or several objects of the class \emph{lm}, which are obtained from the fit of normal linear models.}

\item{digits}{an (optional) integer value indicating the number of decimal places to be used. By default, \code{digits} is set to be 4.}

\item{verbose}{an (optional) logical indicating if should the report of results be printed. By default, \code{verbose} is set to be TRUE.}
}
\value{
a matrix with the following columns
\tabular{ll}{
\code{RSS} \tab value of the residual sum of squares,\cr
\tab \cr
\code{R-squared} \tab value of the R-squared,\cr
\tab \cr
\code{df}       \tab number of parameters in the linear predictor,\cr
\tab \cr
\code{adj.R-squared} \tab value of the adjusted R-squared,\cr
}
}
\description{
Extracts the adjusted R-squared in normal linear models.
}
\details{
The R-squared is computed as \eqn{R^2=1 - RSS/Null.RSS}. Then,
the adjusted R-squared is computed as
\eqn{1 - \frac{n-1}{n-p}(1-R^2)}, where \eqn{p} is the
number of parameters in the linear predictor and \eqn{n} is the sample size.
}
\examples{
###### Example 1: Fuel efficiency of cars
fit1 <- lm(mpg ~ log(hp) + log(wt) + qsec, data=mtcars)
fit2 <- lm(mpg ~ log(hp) + log(wt) + qsec + log(hp)*log(wt), data=mtcars)
fit3 <- lm(mpg ~ log(hp)*log(wt)*qsec, data=mtcars)

AIC(fit1,fit2,fit3)
BIC(fit1,fit2,fit3)
adjR2(fit1,fit2,fit3)

}
