% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overglm3.R
\name{anova.overglm}
\alias{anova.overglm}
\title{Comparison of nested models for alternatives to the Poisson and Binomial Regression Models under the presence of Overdispersion.}
\usage{
\method{anova}{overglm}(object, ..., test = c("wald", "lr", "score", "gradient"), verbose = TRUE)
}
\arguments{
\item{object}{an object of the class \emph{overglm}.}

\item{...}{another objects of the class \emph{overglm}.}

\item{test}{an (optional) character string which allows to specify the required test. The available options are: Wald ("wald"),
Rao's score ("score"), likelihood ratio ("lr") and Terrell's gradient ("gradient") tests. By default, \code{test} is
set to be "wald".}

\item{verbose}{an (optional) logical indicating if should the report of results be printed. By default, \code{verbose}
is set to be TRUE.}
}
\value{
A matrix with the following three columns:
\tabular{ll}{
\code{Chi} \tab The value of the statistic of the test,\cr
\tab \cr
\code{Df}\tab The number of degrees of freedom,\cr
\tab \cr
\code{Pr(>Chi)} \tab The \emph{p}-value of the \code{test}-type test computed using the Chi-square distribution.\cr
}
}
\description{
Allows to compare nested models for regression models based on the negative binomial, beta-binomial, and random-clumped binomial
distributions, which are alternatives to the Poisson and binomial regression models under the presence of overdispersion.
The comparisons are performed by using the Wald, score, gradient or likelihood ratio tests.
}
\examples{
## Example 1: Self diagnozed ear infections in swimmers
data(swimmers)
fit1 <- overglm(infections ~ frequency, family="nb1(log)", data=swimmers)
fit2 <- update(fit1, . ~ . + location)
fit3 <- update(fit2, . ~ . + age)
fit4 <- update(fit3, . ~ . + gender)
anova(fit1, fit2, fit3, fit4, test="wald")
anova(fit1, fit2, fit3, fit4, test="score")
anova(fit1, fit2, fit3, fit4, test="lr")
anova(fit1, fit2, fit3, fit4, test="gradient")

## Example 2: Agents to stimulate cellular differentiation
data(cellular)
fit1 <- overglm(cbind(cells,200-cells) ~ tnf, family="bb(logit)", data=cellular)
fit2 <- update(fit1, . ~ . + ifn)
fit3 <- update(fit2, . ~ . + tnf:ifn)
anova(fit1, fit2, fit3, test="wald")
anova(fit1, fit2, fit3, test="score")
anova(fit1, fit2, fit3, test="lr")
anova(fit1, fit2, fit3, test="gradient")

}
\references{
Buse A. (1982) The Likelihood Ratio, Wald, and Lagrange Multiplier Tests: An Expository Note.
                            \emph{The American Statistician} 36, 153-157.

Terrell G.R. (2002) The gradient statistic. \emph{Computing Science and Statistics} 34, 206–215.
}
