% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizedGini.R
\name{normalizedGini}
\alias{normalizedGini}
\title{Calculating the normalized Gini index}
\usage{
normalizedGini(actual, predicted)
}
\arguments{
\item{actual}{The numeric binary vector of the actual labels observed.}

\item{predicted}{The vector of the probabilities predicted by the classification rule.}
}
\value{
The Gini index of the predicted probabilities as a single `num`.
}
\description{
This function calculates the Gini index of a classification rule outputting probabilities. It is a classical metric in the context of Credit Scoring.
It is equal to 2 times the AUC (Area Under ROC Curve) minus 1.
}
\examples{
normalizedGini(c(1,1,1,0,0),c(0.7,0.9,0.5,0.6,0.3))
}
\author{
Adrien Ehrhardt
}
\keyword{gini}
\keyword{index}
