% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glottocolors.R
\name{glottospotlight}
\alias{glottospotlight}
\title{Highlight certain data points in visualizations}
\usage{
glottospotlight(
  glottodata,
  spotcol,
  spotlight,
  spotcontrast = NULL,
  spotpal = NULL,
  bgcontrast = NULL,
  bgpal = NULL
)
}
\arguments{
\item{glottodata}{User-provided glottodata}

\item{spotcol}{Name of the column that contains the data to put in the spotlights (as well as remaining background data).}

\item{spotlight}{Selection of data to put in the spotlights.}

\item{spotcontrast}{Optional column to contrast between data points in the spotlight.}

\item{spotpal}{color palette for spotligbht points}

\item{bgcontrast}{Optional column to contrast between background data points}

\item{bgpal}{color palette for background points (default is grays)}
}
\value{
A glottodata object with columns added to be used in visualization.
}
\description{
This function creates two separate color scales: one for points to highlight,
and a second for the remaining background points. It also creates a legend.
This is useful for preparing the data for visualizations such as maps or
other plots.
}
\examples{
\donttest{
glottodata <- glottofilter(country = c("Netherlands", "Germany", "Belgium") )
glottodata <- glottospotlight(glottodata = glottodata, spotcol = "country",
spotlight = "Netherlands", spotcontrast = "name")
glottomap(glottodata, color = "color")
}
}
