% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmSpatialModel.R
\name{make.gmCompositionalMPSSpatialModel}
\alias{make.gmCompositionalMPSSpatialModel}
\title{Construct a Multi-Point gmSpatialModel for regionalized compositions}
\usage{
make.gmCompositionalMPSSpatialModel(
  data,
  coords = attr(data, "coords"),
  V = "ilr",
  prefix = NULL,
  model = NULL
)
}
\arguments{
\item{data}{either a \code{\link[compositions:acomp]{compositions::acomp()}} compositional data set, or else a \code{\link[sp:SpatialPoints]{sp::SpatialPointsDataFrame()}} containing it}

\item{coords}{the coordinates of the sampling locations, if no SpatialPointsDataFrame was provided}

\item{V}{optionally, a matrix of logcontrasts, or else one of the following strings: "alr", "ilr" or "clr";
to produce a plot of the empirical variogram in the corresponding representation; default to variation-variograms}

\item{prefix}{the desired prefix name for the logratio variables, if this is wished to be forced; otherwise derived from \code{V}}

\item{model}{a training image, of any appropriate class (typically a \code{\link[sp:SpatialGridDataFrame]{sp::SpatialGridDataFrame()}} or \code{\link[sp:SpatialGridDataFrame]{sp::SpatialPixelsDataFrame()}})}
}
\value{
A "gmSpatialModel" object with all information provided appropriately structured. See \linkS4class{gmSpatialModel}.
}
\description{
Construct a regionalized compositional data container to be used for multipoint geostatistics.
}
\seealso{
\code{\link[=DirectSamplingParameters]{DirectSamplingParameters()}} for specifying a direct simulation method parameters,
\link{predict_gmSpatialModel} for running the simulation

Other gmSpatialModel: 
\code{\link{Predict}()},
\code{\link{as.gmSpatialModel}()},
\code{\link{gmSpatialModel-class}},
\code{\link{make.gmCompositionalGaussianSpatialModel}()},
\code{\link{make.gmMultivariateGaussianSpatialModel}()}
}
\concept{gmSpatialModel}
