% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compositionsCompatibility.R
\name{LMCAnisCompo}
\alias{LMCAnisCompo}
\title{Create a anisotropic model for regionalized compositions}
\usage{
LMCAnisCompo(
  Z,
  models = c("nugget", "sph", "sph"),
  azimuths = rep(0, length(models)),
  ranges = matrix(1, nrow = length(models), ncol = G),
  sillarray = NULL,
  V = NULL,
  tol = 1e-12,
  G = 2
)
}
\arguments{
\item{Z}{compositional data set, used to derive the compositional dimension and colnames}

\item{models}{string (or vector of strings) specifying which reference model(s) to use}

\item{azimuths}{typically a vector providing, for each model, the direction of maximal continuity}

\item{ranges}{typically a \code{G}-column matrix providing the minimal and maximal ranges, with one row per model
(with \code{G} specified below)}

\item{sillarray}{array of sills for each model. It can be null (to be estimated in the future). If specified,
provide an appropriate \verb{(x,x,K)}-array, where \code{K} is the number of models given, and \code{x} is explained below.}

\item{V}{depending on what do you give as sillarray, you may need to provide the matrix of logcontrasts, or
a string indicating whether the sills are represented in "alr" or "ilr"}

\item{tol}{tolerance for determination of positive definiteness}

\item{G}{one of c(1, 2, 3) identifying if we are in 1D, 2D or 3D cases}
}
\value{
an object of class "LMCAnisCompo" with all provided information appropriately structured,
ready to be used for fitting, plotting or prediction.
}
\description{
Creates a (potentially anisotropic) variogram model for variation-variograms
}
\examples{
data("jura", package="gstat")
Zc = compositions::acomp(jura.pred[,7:9])
LMCAnisCompo(Zc, models=c("nugget", "sph"), azimuths=c(0,45))
}
