% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geostats.R
\name{gsi.Cokriging}
\alias{gsi.Cokriging}
\title{Cokriging of all sorts, internal function}
\usage{
gsi.Cokriging(
  Xout,
  Xin,
  Zin,
  vgram,
  Fin = rep(1, nrow(Xin)),
  Fout = rep(1, nrow(Xout)),
  krigVar = FALSE,
  tol = 1e-15
)
}
\arguments{
\item{Xout}{(M,g)-matrix with coordinates of desired interpolation locations}

\item{Xin}{(N,g)-matrix with coordinates of conditioning locations}

\item{Zin}{(N,D)-matrix with condtioning observations}

\item{vgram}{D-dimensional variogram model of class "gmCgram"}

\item{Fin}{either NULL or a (N,p)-matrix with the base functions of the trend evaluated at
the conditioning locations (defaults to a vector of $N$ 1's)}

\item{Fout}{either NULL or a (m,p)-matrix with the base functions of the trend evaluated at
the conditioning locations (defaults to a vector of $M$ 1's)}

\item{krigVar}{logical or NA, should kriging variances be returned? FALSE=no,
TRUE=give point-wise cokriging covariance; NA=return the whole covariance matrix of all points}

\item{tol}{tolerance for the inversion of the cokriging matrix (in case of near-singularity)}
}
\value{
A (M,D)-matrix of predictions, eventually with an attribute "krigVar"
containing the output defined by argument \code{krigVar}
}
\description{
internal function to compute cokriging (simple, ordinary, universal, with trend)
}
