% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ci_wave_variance}
\alias{ci_wave_variance}
\title{Generate a Confidence intervval for a Univariate Time Series}
\usage{
ci_wave_variance(signal_modwt_bw, wv, type = "eta3", alpha_ov_2 = 0.025,
  robust = FALSE, eff = 0.6)
}
\arguments{
\item{signal_modwt_bw}{A \code{field<vec>} that contains the brick walled modwt or dwt decomposition}

\item{wv}{A \code{vec} that contains the wave variance.}

\item{type}{A \code{String} indicating the confidence interval being calculated.}

\item{alpha_ov_2}{A \code{double} that indicates the \eqn{\left(1-p\right)*\alpha}{(1-p)*alpha} confidence level.}

\item{robust}{A \code{boolean} to determine the type of wave estimation.}

\item{eff}{A \code{double} that indicates the efficiency.}
}
\value{
A \code{matrix} with the structure:
\itemize{
 \item{Column 1}{Wavelet Variance}
 \item{Column 2}{Chi-squared Lower Bounds}
 \item{Column 3}{Chi-squared Upper Bounds}
}
}
\description{
Computes an estimate of the multiscale variance and a chi-squared confidence interval
}
\details{
This function can be expanded to allow for other confidence interval calculations.
}
\examples{
set.seed(1337)
x = rnorm(100)
# Uses the internal MODWT function not associated with an S3 class.
decomp = modwt_cpp(x, "haar", 4, boundary="periodic")
signal_modwt_bw = brick_wall(decomp, select_filter("haar"), "modwt")
y = wave_variance(signal_modwt_bw)
ci_wave_variance(signal_modwt_bw, y, type = "eta3", alpha_ov_2 = 0.025)
}
\keyword{internal}

