% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wvar.R
\name{wvar}
\alias{wvar}
\title{Wavelet Variance}
\usage{
wvar(x, alpha = 0.05, robust = FALSE, eff = 0.6)
}
\arguments{
\item{x}{A \code{vector} with dimensions N x 1, or a \code{lts} object, or a \code{gts} object.}

\item{alpha}{A \code{double} that indicates the \eqn{\left(1-p\right)*\alpha}{(1-p)*alpha} confidence level}

\item{robust}{A \code{boolean} that triggers the use of the robust estimate.}

\item{eff}{A \code{double} that indicates the efficiency as it relates to an MLE.}
}
\value{
A \code{list} with the structure:
\itemize{
  \item{"variance"}{Wavelet Variance},
  \item{"ci_low"}{Lower CI}
  \item{"ci_high"}{Upper CI}
  \item{"robust"}{Robust active}
  \item{"eff"}{Efficiency level for Robust}
  \item{"alpha"}{p value used for CI}
}
}
\description{
Calculates the (MODWT) wavelet variance
}
\examples{
set.seed(999)
x=rnorm(100)
# Default
wvar(x)
# Robust
wvar(x, robust = TRUE, eff=0.3)
# 90\% confidence interval
wvar(x, alpha = 0.10)
}
\author{
JJB
}

