% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot.gnsstsmodel}
\alias{plot.gnsstsmodel}
\title{Plotting method for a \code{gnsstsmodel} object.}
\usage{
\method{plot}{gnsstsmodel}(
  x,
  main = NULL,
  y_unit = "mm",
  x_unit = "days",
  legend_position = "bottomright",
  legend_position_wv = "bottomleft",
  ...
)
}
\arguments{
\item{x}{A \code{gnsstsmodel} object.}

\item{main}{A \code{string} specifying the title of the plot.}

\item{y_unit}{A \code{string} specifying the y axis label of the plot.}

\item{x_unit}{A \code{string} specifying the x axis label of the plot.}

\item{legend_position}{A \code{string} specifying the legend position of the plot.}

\item{legend_position_wv}{A \code{string} specifying the legend position for the wv plot.}

\item{...}{Additional graphical parameters.}
}
\value{
No return value. Plot a \code{gnsstsmodel} object.
}
\description{
Plotting method for a \code{gnsstsmodel} object.
}
\examples{
data(cola)
fit_gmwmx = estimate_gmwmx(x = cola,
                           theta_0 = c(0.1,0.1,0.1,0.1), 
                           n_seasonal = 1, 
                           model_string = "wn+matern")
plot(fit_gmwmx)
}
