% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dominance_CaseControl_model.R
\name{dominance_CC.calc}
\alias{dominance_CC.calc}
\title{Genetic dominance effects on a case control variable}
\usage{
dominance_CC.calc(
  cc,
  g,
  yob = rep(-1, length(cc)),
  sex = rep(-1, length(cc)),
  round_imputed = FALSE,
  covariates = as.data.frame(matrix(0, nrow = 0, ncol = 0))
)
}
\arguments{
\item{cc}{A case control vector, containing 0's and 1's}

\item{g}{A vector with (possibly imputed) genotype values. All entries should be larger than 0 and smaller than 2.}

\item{yob}{A numerical vector containing year of birth. If some are unknown they should be marked as -1}

\item{sex}{A numerical vector containing sex, coded 0 for males, 1 for females and -1 for unknown}

\item{round_imputed}{A boolian variable determining whether imputed genotype values should be rounded to the nearest integer in the analysis}

\item{covariates}{A dataframe containing any other covariates that should be used; one column per covariate.}
}
\value{
A list with the dominanc effect (on log-scale) and corresponding standard error, z statistic and p-value
}
\description{
This function estimates the dominance effect of a genetic variant on a case-control variable
We apply a logistic regression model to estimate dominance effects.
We include a linear term, coded as 0,1 and 2 for non-carriers, heterozygotes and homozygous carriers of the effect allele.
We also include a dominance term, coded as 1 for homozygous carriers and 0 for others.
Effect size and significance is based on the dominance term.
}
\examples{
g_vec <- rbinom(100000, 2, 0.3)
cc_vec <- rbinom(100000, 1, 0.1 * (1.2 ^ (g_vec^2)))
res <- dominance_CC.calc(cc_vec, g_vec)
}
