% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests_KS.R
\name{gofKS}
\alias{gofKS}
\title{The KS gof test using the empirical copula}
\usage{
gofKS(
  copula = c("normal", "t", "clayton", "gumbel", "frank", "joe", "amh", "galambos",
    "huslerReiss", "tawn", "tev", "fgm", "plackett"),
  x,
  param = 0.5,
  param.est = TRUE,
  df = 4,
  df.est = TRUE,
  margins = "ranks",
  flip = 0,
  M = 1000,
  dispstr = "ex",
  lower = NULL,
  upper = NULL,
  seed.active = NULL,
  processes = 1
)
}
\arguments{
\item{copula}{The copula to test for. Possible are \code{"normal"}, 
\code{"t"}, \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"joe"}, 
\code{"amh"}, \code{"galambos"}, \code{"huslerReiss"}, \code{"tawn"}, 
\code{"tev"}, \code{"fgm"} and \code{"plackett"}.}

\item{x}{A matrix containing the data with rows being observations and
columns being variables.}

\item{param}{The copula parameter to use, if it shall not be estimated.}

\item{param.est}{Shall be either \code{TRUE} or \code{FALSE}. \code{TRUE}
means that \code{param} will be estimated.}

\item{df}{Degrees of freedom, if not meant to be estimated. Only necessary
if tested for \code{"t"}-copula.}

\item{df.est}{Indicates if \code{df} shall be estimated. Has to be either
\code{FALSE} or \code{TRUE}, where \code{TRUE} means that it will be
estimated.}

\item{margins}{Specifies which estimation method for the margins shall be
used. The default is \code{"ranks"}, which is the standard approach to
convert data in such a case. Alternatively the following distributions can
be specified: \code{"beta"}, \code{"cauchy"}, Chi-squared (\code{"chisq"}),
\code{"f"}, \code{"gamma"}, Log normal (\code{"lnorm"}), Normal
(\code{"norm"}), \code{"t"}, \code{"weibull"}, Exponential (\code{"exp"}).
Input can be either one method, e.g. \code{"ranks"}, which will be used for
estimation of all data sequences. Also an individual method for each margin
can be specified, e.g. \code{c("ranks", "norm", "t")} for 3 data sequences.
If one does not want to estimate the margins, set it to \code{NULL}.}

\item{flip}{The control parameter to flip the copula by 90, 180, 270 degrees
clockwise. Only applicable for bivariate copula. Default is 0 and possible 
inputs are 0, 90, 180, 270 and NULL.}

\item{M}{Number of bootstrapping loops.}

\item{dispstr}{A character string specifying the type of the symmetric
positive definite matrix characterizing the elliptical copula. Implemented
structures are "ex" for exchangeable and "un" for unstructured, see package
\code{copula}.}

\item{lower}{Lower bound for the maximum likelihood estimation of the copula
parameter. The constraint is also active in the bootstrapping procedure. The
constraint is not active when a switch to inversion of Kendall's tau is
necessary. Default \code{NULL}.}

\item{upper}{Upper bound for the maximum likelihood estimation of the copula
parameter. The constraint is also active in the bootstrapping procedure. The
constraint is not active when a switch to inversion of Kendall's tau is
necessary. Default \code{NULL}.}

\item{seed.active}{Has to be either an integer or a vector of M+1 integers.
If an integer, then the seeds for the bootstrapping procedure will be
simulated. If M+1 seeds are provided, then these seeds are used in the
bootstrapping procedure. Defaults to \code{NULL}, then \code{R} generates
the seeds from the computer runtime. Controlling the seeds is useful for
reproducibility of a simulation study to compare the power of the tests or
for reproducibility of an empirical study.}

\item{processes}{The number of parallel processes which are performed to
speed up the bootstrapping. Shouldn't be higher than the number of logical
processors. Please see the details.}
}
\value{
An object of the \code{class} gofCOP with the components
\item{method}{a character which informs about the performed analysis}
\item{copula}{the copula tested for} \item{margins}{the method used to
estimate the margin distribution.} \item{param.margins}{the parameters of
the estimated margin distributions. Only applicable if the margins were not
specified as \code{"ranks"} or \code{NULL}.} \item{theta}{dependence
parameters of the copulae} \item{df}{the degrees of freedem of the copula.
Only applicable for t-copula.} \item{res.tests}{a matrix with the p-values
and test statistics of the hybrid and the individual tests}
}
\description{
\code{\link{gofKS}} performs the \code{"KS"} gof test for copulae 
and compares the empirical copula against a parametric estimate of the 
copula derived under the null hypothesis. The margins can be estimated by a 
bunch of distributions and the time which is necessary for the estimation 
can be given. The approximate p-values are computed with a parametric 
bootstrap, which computation can be accelerated by enabling in-build parallel 
computation. The gof statistics are computed with the function 
\code{\link[copula]{gofTstat}} from the package copula. It is possible to insert 
datasets of all dimensions above 1 and the possible copulae are 
\code{"normal"}, \code{"t"}, \code{"clayton"}, \code{"gumbel"}, 
\code{"frank"}, \code{"joe"}, \code{"amh"}, \code{"galambos"}, 
\code{"huslerReiss"}, \code{"tawn"}, \code{"tev"}, \code{"fgm"} and 
\code{"plackett"}. The parameter estimation is performed with pseudo maximum 
likelihood method. In case the estimation fails, inversion of 
Kendall's tau is used.
}
\details{
With the pseudo observations \eqn{U_{ij}}{U[ij]} for \eqn{i = 1, \dots,n}{i
= 1, ...,n}, \eqn{j = 1, \dots,d}{j = 1, ...,d} and \eqn{\mathbf{u} \in
[0,1]^d}{u in [0,1]^d} is the empirical copula given by \eqn{C_n(\mathbf{u})
= \frac{1}{n} \sum_{i = 1}^n \mathbf{I}(U_{i1} \leq u_1, \dots, U_{id} \leq
u_d).}{1/n sum(U[i1] <= u_1, ..., U[id] <= u_d, i = 1, ..., n).} It shall be
tested the \eqn{H_0}{H0} hypothesis: \deqn{C \in \mathcal{C}_0}{C in Ccal0}
with \eqn{\mathcal{C}_0}{Ccal0} as the true class of copulae under
\eqn{H_0}{H0}. The resulting Kolmogorov-Smirnof test statistic is then 
given by \deqn{T = \sqrt{n} \sup_{v \in [0,1]} |C_n(v) - C_{\theta_n}| 
}{T = n^{1/2} sup_{v in [0,1]} |Cn(v) - Cthetan| } with 
\eqn{C_{\theta_n}(\mathbf{u})}{Cthetan(u)} the estimation of \eqn{C}
under the \eqn{H_0}{H0}.

The approximate p-value is computed by the formula,

\deqn{\sum_{b=1}^M \mathbf{I}(|T_b| \geq |T|) / M,}{sum(|T[b]| >= |T|, b=1,
.., M) / M,}

where \eqn{T} and \eqn{T_b}{T[b]} denote the test statistic and the
bootstrapped test statistc, respectively.

For small values of \code{M}, initializing the parallelisation via
\code{processes} does not make sense. The registration of the parallel
processes increases the computation time. Please consider to enable
parallelisation just for high values of \code{M}.
}
\examples{

data(IndexReturns2D)

gofKS("normal", IndexReturns2D, M = 10)

}
\references{
Rosenblatt, M. (1952). Remarks on a Multivariate Transformation.
\emph{The Annals of Mathematical Statistics 23, 3, 470-472}.\cr \cr Hering,
C. and Hofert, M. (2014). Goodness-of-fit tests for Archimedean copulas in
high dimensions. \emph{Innovations in Quantitative Risk Management}.\cr \cr
Marius Hofert, Ivan Kojadinovic, Martin Maechler, Jun Yan (2014). copula:
Multivariate Dependence with Copulas. \emph{R package version 0.999-15.}.
\url{https://cran.r-project.org/package=copula} \cr \cr
}
