% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_diagnostics.R
\name{examine}
\alias{examine}
\alias{examineOutliers}
\alias{examineChangepoints}
\title{Diagnostic functions}
\usage{
examineOutliers(
  x,
  method = c("Hampel", "IQR", "Top"),
  parameter = 3,
  window = NULL
)

examineChangepoints(
  x,
  moment = c("mean", "variance"),
  method = c("PELT", "AMOC", "BinSeg"),
  window = NULL,
  ...
)
}
\arguments{
\item{x}{an object of class \code{result.goldfish} output from an
\code{\link{estimate}} call.}

\item{method}{Choice of \code{"AMOC"}, \code{"PELT"} or \code{"BinSeg"}.
For a detail description see \code{\link[changepoint]{cpt.mean}} or
\code{\link[changepoint]{cpt.var}}. The default value is \code{"PELT"}.}

\item{parameter}{An integer that represents the number of absolute outliers
to identify, the threshold for the Hampel filter, i.e. \code{parameter * MAD},
or the threshold beyond the interquartile range halved, i.e. \code{parameter/2 * IQR}.}

\item{window}{The window half-width for the Hampel filter.
By default it is half the width of the event sequence.}

\item{moment}{character argument to choose between "mean" or "variance".
See section \emph{Change point} for details.}

\item{...}{additional arguments to be passed to the functions in the
\code{\link{changepoint}} package.}
}
\value{
\code{NULL} if neither outliers nor change points are identified.
An object of class \code{ggplot} object from a call of \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
It can be modified using the \code{ggplot2} syntax.
}
\description{
Provide diagnostic functions for an object of class \code{result.goldfish}.
\code{outliers} helps to identify outliers events.
\code{changepoints} helps to identify where a change point
in the events sequence is presented using the log-likelihood.
}
\section{Outliers}{

\code{examineOutliers} creates a plot with the log-likelihood of the events
in the y-axis and the event index in the x-axis, identifying observations
with labels indicating the sender and recipient.
}

\section{Change point}{

The parameter \code{moment} controls which method from the package
\code{\link{changepoint}} is used:
\describe{
\item{\code{"mean"}}{It uses the \code{\link[changepoint]{cpt.mean}}
function to investigate optimal positioning and (potentially) number
of change points for the log-likelihood of the events in mean.}
\item{\code{"variance"}}{It uses the
\code{\link[changepoint]{cpt.var}}
function to investigate optimal positioning and (potentially) number
of change points for the log-likelihood of the events in variance}
}
The function call creates a plot with the log-likelihood of the events
in the y-axis and the event index in the x-axis, highlighting the change
point sections identified by the method.
}

\examples{
# A multinomial receiver choice model
data("Social_Evolution")
callNetwork <- defineNetwork(nodes = actors, directed = TRUE)
callNetwork <- linkEvents(
  x = callNetwork, changeEvent = calls,
  nodes = actors
)
callsDependent <- defineDependentEvents(
  events = calls, nodes = actors,
  defaultNetwork = callNetwork
)
\dontshow{
callsDependent <- callsDependent[1:50, ]
}
mod01 <- estimate(callsDependent ~ inertia + recip + trans,
  model = "DyNAM", subModel = "choice",
  estimationInit = list(returnIntervalLogL = TRUE,
                        engine = "default_c")
)

examineOutliers(mod01)

examineChangepoints(mod01)
}
