% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ga_v4_get.R
\name{make_ga_4_req}
\alias{make_ga_4_req}
\title{Make a Google Analytics v4 API fetch}
\usage{
make_ga_4_req(viewId, date_range = NULL, metrics = NULL,
  dimensions = NULL, dim_filters = NULL, met_filters = NULL,
  filtersExpression = NULL, order = NULL, segments = NULL,
  pivots = NULL, cohorts = NULL, pageToken = 0, pageSize = 1000,
  samplingLevel = c("DEFAULT", "SMALL", "LARGE"), metricFormat = NULL,
  histogramBuckets = NULL)
}
\arguments{
\item{viewId}{viewId of data to get.}

\item{date_range}{character or date vector of format \code{c(start, end)} or 
for two date ranges: \code{c(start1,end1,start2,end2)}}

\item{metrics}{Metric to fetch. Supports calculated metrics.}

\item{dimensions}{Dimensions to fetch.}

\item{dim_filters}{A \link{filter_clause_ga4} wrapping \link{dim_filter}}

\item{met_filters}{A \link{filter_clause_ga4} wrapping \link{met_filter}}

\item{filtersExpression}{A v3 API style simple filter string. Not used with other filters.}

\item{order}{An \link{order_type} object}

\item{segments}{List of segments as created by \link{segment_ga4}}

\item{pivots}{Pivots of the data as created by \link{pivot_ga4}}

\item{cohorts}{Cohorts created by \link{make_cohort_group}}

\item{pageToken}{Where to start the data fetch}

\item{pageSize}{How many rows to fetch. Max 100000 each batch.}

\item{samplingLevel}{Sample level}

\item{metricFormat}{If supplying calculated metrics, specify the metric type}

\item{histogramBuckets}{For numeric dimensions such as hour, a list of buckets of data.
See details in \link{make_ga_4_req}}
}
\description{
This function constructs the Google Analytics API v4 call to be called
  via \link{fetch_google_analytics_4}
}
\section{Metrics}{

  Metrics support calculated metrics like ga:users / ga:sessions if you supply
  them in a named vector.

  You must supply the correct 'ga:' prefix unlike normal metrics

  You can mix calculated and normal metrics like so:

  \code{customMetric <- c(sessionPerVisitor = "ga:sessions / ga:visitors",
                          "bounceRate",
                          "entrances")}

   You can also optionally supply a \code{metricFormat} parameter that must be
   the same length as the metrics.  \code{metricFormat} can be:
   \code{METRIC_TYPE_UNSPECIFIED, INTEGER, FLOAT, CURRENCY, PERCENT, TIME}

   All metrics are currently parsed to as.numeric when in R.
}

\section{Dimensions}{


  Supply a character vector of dimensions, with or without \code{ga:} prefix.

  Optionally for numeric dimension types such as
  \code{ga:hour, ga:browserVersion, ga:sessionsToTransaction}, etc. supply
  histogram buckets suitable for histogram plots.

  If non-empty, we place dimension values into buckets after string to int64.
  Dimension values that are not the string representation of an integral value
  will be converted to zero. The bucket values have to be in increasing order.
  Each bucket is closed on the lower end, and open on the upper end.
  The "first" bucket includes all values less than the first boundary,
  the "last" bucket includes all values up to infinity.
  Dimension values that fall in a bucket get transformed to a new dimension
  value. For example, if one gives a list of "0, 1, 3, 4, 7", then we
  return the following buckets: -
\itemize{
  \item bucket #1: values < 0, dimension value "<0"
  \item bucket #2: values in [0,1), dimension value "0"
  \item bucket #3: values in [1,3), dimension value "1-2"
  \item bucket #4: values in [3,4), dimension value "3"
  \item bucket #5: values in [4,7), dimension value "4-6"
  \item bucket #6: values >= 7, dimension value "7+"
 }
}

\examples{

\dontrun{
library(googleAnalyticsR)

## authenticate, 
## or use the RStudio Addin "Google API Auth" with analytics scopes set
ga_auth()

## get your accounts
account_list <- google_analytics_account_list()

## pick a profile with data to query

ga_id <- account_list[23,'viewId']

ga_req1 <- make_ga_4_req(ga_id, 
                         date_range = c("2015-07-30","2015-10-01"),
                         dimensions=c('source','medium'), 
                         metrics = c('sessions'))

ga_req2 <- make_ga_4_req(ga_id, 
                         date_range = c("2015-07-30","2015-10-01"),
                         dimensions=c('source','medium'), 
                         metrics = c('users'))
                         
fetch_google_analytics_4(list(ga_req1, ga_req2))

}


}
\seealso{
Other GAv4 fetch functions: \code{\link{fetch_google_analytics_4_slow}},
  \code{\link{fetch_google_analytics_4}},
  \code{\link{google_analytics}}
}
