% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{gar_shiny_getAuthUrl}
\alias{gar_shiny_getAuthUrl}
\title{Returns the Google authentication URL}
\usage{
gar_shiny_getAuthUrl(redirect.uri,
  state = getOption("googleAuthR.securitycode"),
  client.id = getOption("googleAuthR.webapp.client_id"),
  client.secret = getOption("googleAuthR.webapp.client_secret"),
  scope = getOption("googleAuthR.scopes.selected"),
  access_type = c("online", "offline"), approval_prompt = c("auto",
  "force"))
}
\arguments{
\item{redirect.uri}{App URL, from \code{gar_shiny_getUrl}}

\item{state}{A random string used to check auth is from same origin.}

\item{client.id}{From the Google API console.}

\item{client.secret}{From the Google API console.}

\item{scope}{What Google API service to get authentication for.}
}
\value{
The URL for authentication.
}
\description{
The URL a user authenticates the Shiny app on.
}
\seealso{
Other shiny auth functions: \code{\link{authReturnCode}},
  \code{\link{createCode}},
  \code{\link{gar_shiny_getToken}},
  \code{\link{gar_shiny_getUrl}},
  \code{\link{loginOutput}},
  \code{\link{reactiveAccessToken}},
  \code{\link{renderLogin}},
  \code{\link{revokeEventObserver}},
  \code{\link{with_shiny}}
}
\keyword{internal}
