% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildsteps_templates.R
\name{cr_buildstep_gitsetup}
\alias{cr_buildstep_gitsetup}
\alias{cr_buildstep_git}
\title{Create a build step for authenticating with Git}
\usage{
cr_buildstep_gitsetup(
  keyring = "my-keyring",
  key = "github-key",
  cipher = "id_rsa.enc",
  ...
)

cr_buildstep_git(
  git_args = c("clone", "git@github.com:[GIT-USERNAME]/[REPOSITORY]", "."),
  ...
)
}
\arguments{
\item{keyring}{The Key Management Store keyring containing the git ssh key}

\item{key}{The Key Management Store key containing the gitssh key}

\item{cipher}{The filename of the encrypted git ssh key that has been checked into the repository}

\item{...}{Further arguments passed in to \link{cr_buildstep}}

\item{git_args}{The arguments to send to git}
}
\description{
This creates steps to configure git to use an ssh created key.

This creates steps to use git with an ssh created key.
}
\details{
The key should be encrypted offline using \code{gcloud kms} or similar first.  See \link{cr_buildstep_decrypt} for details.

By default the encrypted key should then be at the root of your \link{Source} object called "id_rsa.enc"

\code{cr_buildstep} must come after \code{cr_buildstep_gitsetup}
}
\examples{
cr_project_set("my-project")
cr_bucket_set("my-bucket")

# assumes you have previously saved git ssh key via KMS called "git_key"
cr_build_yaml(
     steps = c(
          cr_buildstep_gitsetup("my_keyring", "git_key"),
          cr_buildstep_git(c("clone",
                             "git@github.com:github_name/repo_name"))
     )
 )

}
\seealso{
\href{https://cloud.google.com/cloud-build/docs/access-private-github-repos}{Accessing private GitHub repositories using Cloud Build (google article)}

Other Cloud Buildsteps: 
\code{\link{cr_buildstep_bash}()},
\code{\link{cr_buildstep_decrypt}()},
\code{\link{cr_buildstep_df}()},
\code{\link{cr_buildstep_docker}()},
\code{\link{cr_buildstep_edit}()},
\code{\link{cr_buildstep_extract}()},
\code{\link{cr_buildstep_mailgun}()},
\code{\link{cr_buildstep_nginx_setup}()},
\code{\link{cr_buildstep_pkgdown}()},
\code{\link{cr_buildstep_run}()},
\code{\link{cr_buildstep_r}()},
\code{\link{cr_buildstep_slack}()},
\code{\link{cr_buildstep}()}
}
\concept{Cloud Buildsteps}
