% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{gcs_get_object}
\alias{gcs_get_object}
\title{Get an object in a bucket directly}
\usage{
gcs_get_object(object_name, bucket = gcs_get_global_bucket(), meta = FALSE,
  saveToDisk = NULL, parseObject = TRUE)
}
\arguments{
\item{object_name}{name of object in the bucket. URL encoded.}

\item{bucket}{bucket containing the objects}

\item{meta}{If TRUE then get info about the object, not the object itself}

\item{saveToDisk}{Specify a filename to save directly to disk.}

\item{parseObject}{If saveToDisk is NULL, whether to parse with \link{gcs_parse_download}}
}
\value{
The object, or TRUE if sucessfully saved to disk.
}
\description{
This retrieves an object directly.
This differs from providing downloads via a download link as you can
  do via \link{gcs_download_url}
}
\seealso{
Other object functions: \code{\link{gcs_delete_object}},
  \code{\link{gcs_list_objects}},
  \code{\link{gcs_metadata_object}}
}

