% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/instances_admin.R
\name{gce_list_instances}
\alias{gce_list_instances}
\title{Retrieves the list of instances contained within the specified zone.}
\usage{
gce_list_instances(filter = NULL, maxResults = NULL, pageToken = NULL,
  project = gce_get_global_project(), zone = gce_get_global_zone())
}
\arguments{
\item{filter}{Sets a filter expression for filtering listed resources, in the form filter={expression}}

\item{maxResults}{The maximum number of results per page that should be returned}

\item{pageToken}{Specifies a page token to use}

\item{project}{Project ID for this request}

\item{zone}{The name of the zone for this request}
}
\description{
Retrieves the list of instances contained within the specified zone.
}
\details{
Authentication scopes used by this function are:
\itemize{
  \item https://www.googleapis.com/auth/cloud-platform
\item https://www.googleapis.com/auth/compute
\item https://www.googleapis.com/auth/compute.readonly
}

To filter you need a single string in the form \code{field_name eq|ne string} 
  e.g. \code{gce_list_instances("status eq RUNNING")} where \code{eq} is 'equals' and \code{ne} is 'not-equals'.
}
\seealso{
\href{https://developers.google.com/compute/docs/reference/latest/}{Google Documentation}
}

