% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future.R
\name{as.cluster.gce_instance}
\alias{as.cluster.gce_instance}
\title{Create a future cluster for GCE objects}
\usage{
\method{as.cluster}{gce_instance}(x, project = gce_get_global_project(),
  zone = gce_get_global_zone(), rshopts = ssh_options(x), ...,
  recursive = FALSE)
}
\arguments{
\item{x}{The instance to make a future cluster}

\item{project}{The GCE project}

\item{zone}{The GCE zone}

\item{rshopts}{Options for the SSH}

\item{...}{Other arguments passed to makeDockerClusterPSOCK}

\item{recursive}{Not used.}
}
\value{
A \code{cluster} object.
}
\description{
S3 method for \code{\link[future:as.cluster]{as.cluster}()} in the \pkg{future} package.
}
\details{
Only works for r-base containers created via \code{gce_vm_template("r-base")} or for 
  docker containers created using the \code{--net=host} argument flag
}
\examples{
\donttest{\dontrun{
vm <- gce_vm("r-base", name = "future", predefined_type = "f1-micro")
plan(cluster, workers = vm)  ## equivalent to workers = as.cluster(vm)
x \%<-\% { Sys.getinfo() }
print(x)
}}

}
