% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harbor_gce.R
\name{docker_build}
\alias{docker_build}
\title{Build image on an instance from a local Dockerfile}
\usage{
docker_build(host = localhost, dockerfolder, new_image,
  folder = "buildimage", wait = FALSE, ...)
}
\arguments{
\item{host}{A host object.}

\item{dockerfolder}{Local location of build directory including valid \code{Dockerfile}}

\item{new_image}{Name of the new image}

\item{folder}{Where on host to build dockerfile}

\item{wait}{Whether to block R console until finished build}

\item{...}{Other arguments passed to the SSH command for the host}
}
\value{
A table of active images on the instance
}
\description{
Uploads a folder with a \code{Dockerfile} and supporting files to an instance and builds it
}
\details{
Dockerfiles are best practice when creating your own docker images, 
rather than logging into a Docker container, making changes and committing.
}
\examples{
\dontrun{
docker_build(localhost, "/home/stuff/dockerfolder" ,"new_image", wait = TRUE)
docker_run(localhost, "new_image")
}
}
\seealso{
\href{https://docs.docker.com/engine/userguide/eng-image/dockerfile_best-practices/}{Best practices for writing Dockerfiles}

An example Dockerfile for \href{https://hub.docker.com/r/rocker/ropensci/~/dockerfile/}{rOpensci}

General R Docker images found at \href{https://github.com/rocker-org}{rocker-org}
}
