% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speech.R
\name{gl_speech_op}
\alias{gl_speech_op}
\title{Get a speech operation}
\usage{
gl_speech_op(operation)
}
\arguments{
\item{operation}{A speech operation object from \link{gl_speech} when \code{asynch = TRUE}}
}
\value{
If the operation is still running, another operation object.  If done, the result as per \link{gl_speech}
}
\description{
For asynchronous calls of audio over 60 seconds, this returns the finished job
}
\examples{

\dontrun{

test_audio <- system.file("woman1_wb.wav", package = "googleLanguageR")

## make an asynchronous API request (mandatory for sound files over 60 seconds)
asynch <- gl_speech(test_audio, asynch = TRUE)

## Send to gl_speech_op() for status or finished result
gl_speech_op(asynch)

}

}
\seealso{
\link{gl_speech}
}
