% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_places.R
\name{google_find_place}
\alias{google_find_place}
\title{Google Find Place}
\usage{
google_find_place(
  input,
  inputtype = c("textquery", "phonenumber"),
  language = NULL,
  fields = place_fields(),
  point = NULL,
  circle = NULL,
  rectangle = NULL,
  simplify = TRUE,
  curl_proxy = NULL,
  key = get_api_key("find_place")
)
}
\arguments{
\item{input}{The text input specifying which place to search for
(for example, a name, address, or phone number).}

\item{inputtype}{The type of input. This can be one of either textquery or phonenumber.
Phone numbers must be in international format (prefixed by a plus sign ("+"),
followed by the country code, then the phone number itself).}

\item{language}{\code{string} The language code, indicating in which language
the results should be returned, if possible. Searches are also biased to the
selected language; results in the selected language may be given a higher ranking.
See the list of supported languages and their codes
\url{https://developers.google.com/maps/faq#languagesupport}.}

\item{fields}{vector of place data types to return. All Basic fields are returned by default.
See details}

\item{point}{vector of lat & lon values. Prefer results near this point.}

\item{circle}{list of two elements, point (vector of lat & lon) and radius.
Prefer results in this circle. Ignored if point is supplied}

\item{rectangle}{list of two elements, sw (vector of lat & lon) and ne (vector of lat & lon)
specifying the south-west and north-east bounds of a rectangle. Prefer results
in this rectangle. Ignored if either point or circle are supplied}

\item{simplify}{\code{logical} - TRUE indicates the returned JSON will be coerced into a list. FALSE indicates the returend JSON will be returned as a string
into a list.}

\item{curl_proxy}{a curl proxy object}

\item{key}{\code{string} A valid Google Developers Places API key.}
}
\description{
A Find Place request takes a text input, and returns a place.
The text input can be any kind of Places data, for example, a name, address, or phone number
}
\details{
Fields correspond to place search results
 \url{https://developers.google.com/places/web-service/search#PlaceSearchResults}
and are divided into three billing categories: Basic, Contact and Atmosphere.

Basic fields are billed at base rate, and incur no additional charges. Contact
and atmosphere fields are billed at a hihger rate. See pricing sheet for more information
\url{https://cloud.google.com/maps-platform/pricing/sheet/?__utma=102347093.1187532699.1510801584.1537138439.1537138439.1&__utmb=102347093.0.10.1537138439&__utmc=102347093&__utmx=-&__utmz=102347093.1537138439.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none)&__utmv=-&__utmk=133826830&_ga=2.227832157.1738618203.1537137400-1187532699.1510801584}

\itemize{
 \item{Basic - }{formatted_address, geometry, icon, id, name, permanently_closed, photos, place_id, plus_code, types}
 \item{Contact - }{opening_hours}
 \item{Atmosphere - }{price_level, rating}
}
}
\examples{
\donttest{

## specifying fields

set_key( "your_api_key" )

google_find_place(
  input = "Museum of Contemporary Art Australia"
  , fields = c("photos","formatted_address","name","rating","opening_hours","geometry")
)

## Using location bias - circle
google_find_place(
  input = "Mongolian Grill"
  , circle = list(point = c(47.7, -122.2), radius = 2000)
)

## finding by a phone number
google_find_place(
 input = "+61293744000"
 , inputtype = "phonenumber"
)

}

}
\seealso{
\link{google_place_details} \link{google_places}
}
