% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map_urls.R
\name{google_map_url}
\alias{google_map_url}
\title{Google Map Url}
\usage{
google_map_url(
  center = NULL,
  zoom = 15,
  basemap = c("roadmap", "satellite", "terrain"),
  layer = c("none", "transit", "traffic", "bicycling")
)
}
\arguments{
\item{center}{vector of lat/lon coordinates which defines the centre of the map window}

\item{zoom}{number that sets the zoom level of the map (from 0 to 21)}

\item{basemap}{defines the typ eof map to display.}

\item{layer}{defines an extra layer to display on the map, if any.}
}
\description{
Opens a Google Map in a browser
}
\examples{
\dontrun{

google_map_url()

google_map_url(center = c(-37.817727, 144.968246))

google_map_url(center = c(-37.817727, 144.968246), zoom = 5)

google_map_url(center = c(-37.817727, 144.968246), basemap = "terrain")

google_map_url(center = c(-37.817727, 144.968246), layer = "traffic")

}
}
