% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R, R/restart.R
\name{gpg_options}
\alias{gpg_info}
\alias{gpg_options}
\alias{gpg_restart}
\alias{gpg_version}
\title{GPG options}
\usage{
gpg_options()

gpg_info()

gpg_version(silent = FALSE)

gpg_restart(path = NULL, home = NULL, debug = "none", silent = FALSE)
}
\arguments{
\item{silent}{suppress output of \code{gpg --version}}

\item{path}{location of \code{gpg} or \code{gpg2} or \code{gpgconf} or (on windows) \code{gpgme-w32spawn.exe}}

\item{home}{path to your GPG configuration directory}

\item{debug}{debugging level, integer between 1 and 9}
}
\description{
Get and set options GnuPG configuration options.

Finds the \code{gpg} program and loads a context.
}
\details{
This function reads and edits options in the GnuPG configuration file, which
is stored by default in \code{~/.gnupg/gpg.conf}. Note that changing options
can affect other software using this installation of GnuPG.
}
\examples{
gpg_info()
gpg_version()
}

