% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradDescentR.Methods.R
\name{SARAHPlus}
\alias{SARAHPlus}
\title{Stochastic Recursive Gradient Algorithm+ (SARAH+) Method Learning Function}
\usage{
SARAHPlus(dataTrain, alpha = 0.1, maxIter = 10, innerIter = 10,
  gammaS = 0.125, seed = NULL)
}
\arguments{
\item{dataTrain}{a data.frame that representing training data (\eqn{m \times n}),
where \eqn{m} is the number of instances and \eqn{n} is the number
of variables where the last column is the output variable. dataTrain
must have at least two columns and ten rows of data that contain
only numbers (integer or float).}

\item{alpha}{a float value representing learning rate. Default value is 0.1}

\item{maxIter}{the maximal number of iterations in outerloop.}

\item{innerIter}{the maximal number of iterations in innerloop.}

\item{gammaS}{a float value to provide sufficient reduction. Default value is 0.125}

\item{seed}{a integer value for static random. Default value is NULL, which means
the function will not do static random.}
}
\value{
a vector matrix of theta (coefficient) for linear model.
}
\description{
A function to build prediction model using SARAH+ method.
}
\details{
This function is practical variant of \code{\link{SARAH}}, \code{\link{SARAHPlus}} provides a possibility of
earlier termination and unnecessary careful choices of maximum innerloop size, and it also covers the
classical gradient descent when we set gammaS = 1 (since the while loop does not proceed).
}
\examples{
##################################
## Learning and Build Model with SARAH+
## load R Package data
data(gradDescentRData)
## get z-factor data
dataSet <- gradDescentRData$CompressilbilityFactor
## split dataset
splitedDataSet <- splitData(dataSet)
## build model with SARAH+
SARAHPlusmodel <- SARAHPlus(splitedDataSet$dataTrain)
#show result
print(SARAHPlusmodel)

}
\references{
Lam M. Nguyen, Jie Lu, Katya Scheinberg, Martin Takac
SARAH: A Novel Method for Machine Learning Problems Using Stochastic Recursive Gradient,
arXiv preprint arXiv:1703.00102,
(2017)
}
\seealso{
\code{\link{SVRG}}, \code{\link{SSGD}}, \code{\link{SARAH}}
}
