% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_xy_NumGroup.R
\name{plot_xy_NumGroup}
\alias{plot_xy_NumGroup}
\title{Plot points on a quantitative X - Y plot & a numeric grouping variable.}
\usage{
plot_xy_NumGroup(
  data,
  xcol,
  ycol,
  NumGroup,
  symsize = 2.5,
  symthick = 1,
  s_alpha = 1,
  TextXAngle = 0,
  fontsize = 20
)
}
\arguments{
\item{data}{a data table object, e.g. data.frame or tibble.}

\item{xcol}{name of the column with quantitative X variable.}

\item{ycol}{name of the column with quantitative Y variable.}

\item{NumGroup}{a numeric factor for \code{fill} aesthetic of data points.}

\item{symsize}{size of symbols used by \code{geom_point}. Default set to 2.5, increase/decrease as needed.}

\item{symthick}{thickness of symbol border, default set to 1.}

\item{s_alpha}{fractional opacity of symbols, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function takes a data table, quantitative X and Y variables, and a numeric grouping variable, and a and plots a graph with using \code{\link[ggplot2]{geom_point}}. The numerical \code{NumGroup} variable is mapped to the \code{fill} aesthetic of symbols, which receives the \code{scale_fill_grafify_c} default palette.
}
\details{
This plot is related to \code{\link{plot_xy_CatGroup}} which requires a categorical grouping factor.
When summary statistics (mean/median) are required, use \code{\link{plot_3d_scatterbar}}, \code{\link{plot_3d_scatterbox}} or \code{\link{plot_4d_scatterbox}}.
}
\examples{
#The grouping factor gear is numeric 
plot_xy_NumGroup(data = mtcars,
xcol = mpg, ycol = disp, NumGroup = cyl,
s_alpha = 0.8)
}
