% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_grafify.R
\name{theme_grafify}
\alias{theme_grafify}
\title{A modified \code{theme_classic()} for \code{grafify}-like graphs.}
\usage{
theme_grafify(
  base_size = 20,
  base_family = "",
  base_line_size = base_size/22,
  base_rect_size = base_size/22,
  TextXAngle = 0,
  vjust = 0,
  hjust = 0,
  ...
)
}
\arguments{
\item{base_size}{base font size for all text (default is 20). Other text is relative to this.}

\item{base_family}{default font family}

\item{base_line_size}{default line size (default is base font size/22)}

\item{base_rect_size}{default size of rectangles (default is base font size/22)}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{vjust}{vertical adjustment of X-axis text alignment (between 0 and 1). Set \code{hjust} and \code{vjust} to 1 if \code{TextXAngle = 45}. Try other options if using other angles.}

\item{hjust}{horizontal adjustment of X-axis text alignment (between 0 and 1).  Set \code{hjust} and \code{vjust} to 1 if \code{TextXAngle = 45}. Try other options if using other angles.}

\item{...}{for any other arguments to pass to \code{theme}. A useful one is \code{aspect.ratio = 1} for square plots.}
}
\value{
this returns an output with class "theme" and "gg".
}
\description{
This is a slightly modified \code{\link[ggplot2]{theme_classic}} with two key differences: no border & background for facet panel labels, and font size of text on axes is the same as that of the axes titles (prior to v3.2.0, this was 0.85 times the base font size). The size of text legend title is also same as base font.
}
\details{
Since v3.2.0, \code{theme_grafify} produces transparent backgrounds.
}
\examples{

ggplot(mpg, aes(drv, cty, colour = fl))+
geom_jitter(width = 0.2, 
size = 3, alpha = .7)+
theme_grafify()

}
