% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grandR.R
\name{Plots}
\alias{Plots}
\alias{AddGenePlot}
\alias{AddGlobalPlot}
\alias{PlotGene}
\alias{PlotGlobal}
\alias{DropPlots}
\title{Stored plot functions}
\usage{
Plots(data)

AddGenePlot(data, name, FUN)

AddGlobalPlot(data, name, FUN)

PlotGene(data, name, gene)

PlotGlobal(data, name)

DropPlots(data, pattern = NULL)
}
\arguments{
\item{data}{A grandR object}

\item{name}{The user-defined plot name}

\item{FUN}{The plotting function to add}

\item{gene}{The gene to plot}

\item{pattern}{A regular expression that is matched to plot names}
}
\value{
Either the plot names or a grandR data with added/removed plots
}
\description{
Get plot names and add or remove plots
}
\details{
FUN has to be a function with a single parameter for global plots (i.e., the grandR object) or two parameters for gene plots
(i.e., the grandR object and the gene name). Usually, it is either the name of a plotting function, such as \link{PlotGeneOldVsNew}, or, if it is
necessary to parametrize it, a call to \link{Defer} (which takes care of caching plots without storing an additional copy of the grandR object).
}
\section{Functions}{
\itemize{
\item \code{Plots()}: Obtain the plot names

\item \code{AddGenePlot()}: Add a gene plot to the grandR object

\item \code{AddGlobalPlot()}: Add a global plot to the the grandR object

\item \code{PlotGene()}: Create a gene plot

\item \code{PlotGlobal()}: Create a global plot

\item \code{DropPlots()}: Remove plots from the grandR object

}}
\concept{grandr}
