% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_functions.R
\name{annotate_circle}
\alias{annotate_circle}
\title{annotate concentric circles}
\usage{
annotate_circle(cent, col = "#00BFFF", format = "", pos = "top",
  text_size = 3)
}
\arguments{
\item{cent}{centrality scores used for layout}

\item{col}{color of text}

\item{format}{either empty string or 'scientific'}

\item{pos}{position of text ('top' or 'bottom')}

\item{text_size}{font size for annotations}
}
\value{
annotated concentric circles around origin
}
\description{
annotate concentric circles
}
\details{
this function is best used with \link{layout_with_centrality} together with \link{draw_circle}.
}
\examples{
library(igraph)
library(ggraph)

g <- sample_gnp(10,0.4)

ggraph(g,layout="centrality",cent=closeness(g))+
 draw_circle(use = "cent")+
 annotate_circle(closeness(g),pos = "bottom",format = "scientific")+
 geom_edge_link()+
 geom_node_point(shape=21,fill="grey25",size=5)+
 theme_graph()+
 coord_fixed()
}
