% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basepcor_utils.R
\name{Lprec0}
\alias{Lprec0}
\title{Compute the (lower triangle) Cholesky of the initial precision \code{Q0}.}
\usage{
Lprec0(theta, p, itheta, d0)
}
\arguments{
\item{theta}{numeric parameter vector.}

\item{p}{integer (needed if \code{base} is vector): the dimention.}

\item{itheta}{integer vector or 'graphpcor' to specify the (vectorized)
position where 'theta' is placed in the initial (before the fill-in)
Cholesky (lower triangle) factor. If missing, default, assumes
the dense case as \code{itheta = which(lower.tri(...))}, giving
\code{length(theta)=p(p-1)/2}.}

\item{d0}{numeric vector to specify the diagonal of the
Cholesky factor for the initial precision matrix \code{Q0}.
Default, if not provided, is \code{d0 = p:1}.}
}
\value{
lower triangular matrix
}
\description{
Compute the (lower triangle) Cholesky of the initial precision \code{Q0}.
}
\details{
The (lower triangle) Cholesky factor
of the initial precision for a correlation matrix contains
the parameters in the non-zero elements of the lower triangle side
of the precision matrix.
The filled-in elements are computed from them using \code{\link[=fillLprec]{fillLprec()}}.
}
