% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigma.R
\name{make_sigma}
\alias{make_sigma}
\alias{make_sigma_mat_adjmat}
\alias{make_sigma_mat_graph}
\alias{make_sigma_mat_dist_adjmat}
\alias{make_sigma_mat_dist_graph}
\title{Generate Sigma Matrix}
\usage{
make_sigma_mat_adjmat(mat, cor)

make_sigma_mat_graph(graph, cor, comm = FALSE, directed = FALSE)

make_sigma_mat_dist_adjmat(mat, cor, absolute = FALSE)

make_sigma_mat_dist_graph(graph, cor, absolute = FALSE)
}
\arguments{
\item{mat}{precomputed adjacency, commonlink, or scaled distance matrix.}

\item{cor}{numeric. Simulated maximum correlation/covariance of two adjacent nodes. Default to 0.8.}

\item{graph}{An \code{\link[igraph]{igraph}} object. May be directed or weighted.}

\item{comm}{logical whether a common link matrix is used to compute sigma. Defaults to FALSE (adjacency matrix).}

\item{directed}{logical. Whether directed information is passed to the distance matrix.}

\item{absolute}{logical. Whether distances are scaled as the absolute difference from
the diameter (maximum possible). Defaults to TRUE. The alternative is to calculate a
relative difference from the diameter for a geometric decay in distance.}
}
\value{
a numeric covariance matrix of values in the range [-1, 1]
}
\description{
Compute the Sigma matrix from an \code{\link[igraph]{igraph}} structure 
or pre-computed matrix. These are compatible with \code{\link[mvtnorm]{rmvnorm}} and
\code{\link[graphsim]{generate_expression}}.
}
\examples{

library("igraph")
graph_test_edges <- rbind(c("A", "B"), c("B", "C"), c("B", "D"))
graph_test <- graph.edgelist(graph_test_edges, directed = TRUE)
adjacency_matrix <- make_adjmatrix_graph(graph_test)
sigma_matrix <- make_sigma_mat_adjmat(adjacency_matrix, cor = 0.8)

}
\keyword{graph}
\keyword{igraph}
\keyword{mvtnorm}
\keyword{network}
