% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utililties.R
\name{seq_min_max_eps}
\alias{seq_min_max_eps}
\title{Create a sequence of evenly-spaced values adjusted to accommodate a
small adjustment}
\usage{
seq_min_max_eps(x, n, order, type = c("forward", "backward", "central"),
  eps)
}
\arguments{
\item{x}{numeric; vector over which evenly-spaced values are returned}

\item{n}{numeric; the number of evenly-spaced values to return}

\item{order}{integer; the order of derivative. Either \code{1} or \code{2} for first or
second order derivatives}

\item{type}{character; the type of finite difference used. One of
\code{"forward"}, \code{"backward"}, or \code{"central"}}

\item{eps}{numeric; the finite difference}
}
\value{
A numeric vector of length \code{n}.
}
\description{
Creates a sequence of \code{n} evenly-spaced values over the range
\code{min(x)} -- \code{max(x)}, where the minimum and maximum are adjusted such that
they are always contained within the range of \code{x} when \code{x} may be shifted
forwards or backwards by an amount related to \code{eps}. This is particularly
useful in computing derivatives via finite differences where without this
adjustment we may be predicting for values outside the range of the data
and hence the conmstraints of the penalty.
}
