% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis-funs.R
\name{tidy_basis}
\alias{tidy_basis}
\title{A tidy basis representation of a smooth object}
\usage{
tidy_basis(smooth, data = NULL, at = NULL, coefs = NULL, p_ident = NULL)
}
\arguments{
\item{smooth}{a smooth object of or inheriting from class \code{"mgcv.smooth"}.
Typically, such objects are returned as part of a fitted GAM or GAMM in
the \verb{$smooth} component of the model object or the \verb{$gam$smooth} component
if the model was fitted by \code{\link[mgcv:gamm]{mgcv::gamm()}} or \code{\link[gamm4:gamm4]{gamm4::gamm4()}}.}

\item{data}{a data frame containing the variables used in \code{smooth}.}

\item{at}{a data frame containing values of the smooth covariate(s) at which
the basis should be evaluated.}

\item{coefs}{numeric; an optional vector of coefficients for the smooth}

\item{p_ident}{logical vector; only used for handling \code{\link[scam:scam]{scam::scam()}} smooths.}
}
\value{
A tibble.
}
\description{
Takes an object of class \code{mgcv.smooth} and returns a tidy representation
of the basis.
}
\examples{
load_mgcv()
\dontshow{
op <- options(pillar.sigfig = 3, cli.unicode = FALSE)
}
df <- data_sim("eg1", n = 400, seed = 42)

# fit model
m  <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = df, method = "REML")

# tidy representaition of a basis for a smooth definition
# extract the smooth
sm <- get_smooth(m, "s(x2)")
# get the tidy basis - need to pass where we want it to be evaluated
bf <- tidy_basis(sm, at = df)

# can weight the basis by the model coefficients for this smooth
bf <- tidy_basis(sm, at = df, coefs = smooth_coefs(sm, model = m))
\dontshow{
options(op)
}
}
\author{
Gavin L. Simpson
}
