% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energy_supplement.R
\name{energy_supplement}
\alias{energy_supplement}
\title{Energy supplement}
\source{
\emph{Social Security Guide} by the Department of Social Services. 
Chapter 5, \sQuote{Payment rates}, s. 5.1.10.20 \dQuote{Clean Energy Household Assistance: current rates}.
\url{https://guides.dss.gov.au/guide-social-security-law/5/1/10/20}
}
\usage{
energy_supplement(
  qualifying_payment,
  has_partner = FALSE,
  n_dependants = 0L,
  age = 21,
  lives_at_home = FALSE,
  independent = FALSE,
  isjspceoalfofcoahodeoc = FALSE,
  long_term = FALSE,
  per = c("year", "fortnight", "quarter")
)
}
\arguments{
\item{qualifying_payment}{A character vector designating the payment type the individual is entitled to. Valid strings are
\describe{
\item{pension}{All pensions and bereavement allowance}
\item{seniors health card}{Commonwealth Seniors Health Card}
\item{disability pension}{Disability support pension (over 21)}
\item{allowance}{All allowances not elsewhere described, 
\emph{viz.} Newstart allowance, Widow allowance, Partner allowance, Sickness allowance}
\item{parenting}{Parenting payments}
\item{youth allowance}{Youth allowance (but not receiving youth disability supplement)}
\item{youth disability}{Youth allowance but also receiving youth disability supplement}
\item{austudy}{Austudy recipients}
}}

\item{has_partner}{(logical, default: \code{FALSE}) Does the individual have a partner? For persons with partners but separated due to the partner's illness or imprisonment, this may be true or false depending on the eligibility of the qualifying payment.}

\item{n_dependants}{How many dependants does the individual have? Default is zero.}

\item{age}{The age of the individual.}

\item{lives_at_home}{(logical, default: \code{FALSE}) Does the individual live at home?}

\item{independent}{(logical, default: \code{FALSE}) For persons under 21, is the person 'independent'?}

\item{isjspceoalfofcoahodeoc}{Is the recipient a single job seeker principal carer, either of large family or foster child/ren, or who is a home or distance educator of child/ren?}

\item{long_term}{Is the individual a long-term welfare recipient?}

\item{per}{Dictates whether the result is per year, per fortnight, or per quarter. By default, yearly payments are returned, with a message. Payments are generally made each fortnight though recipients can elect to have them paid quarterly.}
}
\value{
The energy supplement for each individual. Arguments are recycled, but only if length-one.
}
\description{
The energy supplement (ES) is a supplementary payment that 
commenced on 20 September 2014. It was previously known as the clean energy 
supplement (CES). It is a fixed nominal amount; the supplement is neither 
indexed nor increased each year. There is no means testing.
}
