% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inflate.R
\name{Inflate}
\alias{Inflate}
\title{Generic inflator}
\usage{
Inflate(
  from,
  to,
  index,
  x = NULL,
  fy_month = 3L,
  check = 2L,
  nThread = getOption("grattanInflators.nThread", 1L)
)
}
\arguments{
\item{from, to}{Times for which the inflator is desired. If \code{NULL}, a date
range close to the previous year is used.}

\item{index}{A table of at least two columns, named \code{date} and \code{value}.
\code{date} is the
column of times to which \code{from}, \code{to} will be
matched. \code{value} is the values that determine the inflation factor.}

\item{x}{(Advanced) A vector that will be inflated in-place. If \code{NULL},
the default, the return vector is simply the inflation factor for `from`.}

\item{fy_month}{An integer 1-12, the month to be used for
years and financial years in \code{from} or \code{to}. For
financial years, the month is the month of the financial year,
so for example \code{fy_month = 9} and "2015-16" means Sep-2015,
while \code{fy_month = 6} means Jun-2016.}

\item{check}{\code{integer(1)} If \code{0L}, no checks are performed, and
clearly invalid inputs result in \code{NA} in the output. If \code{check = 1L}
an error is performed for bad input; \code{check = 2L} is more thorough.}

\item{nThread}{Number of threads to use.}
}
\value{
If `x` is `NULL`, the default, a numeric vector matching the lengths of `from`
and `to` equal to the ratio between the corresponding values in the column
\code{value}.

If `x` is numeric, those values are multiplied by the inflators, in-place.
}
\description{
Generic inflator
}
