% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.gremlin.R
\name{logLik.gremlin}
\alias{logLik.gremlin}
\alias{AIC.gremlin}
\title{Methods to extract log-likelihood and information criterion of a gremlin
model.}
\usage{
\method{logLik}{gremlin}(object, ...)

\method{AIC}{gremlin}(object, ..., k = 2, fxdDf = FALSE)
}
\arguments{
\item{object}{An object of \code{class} \sQuote{gremlin}.}

\item{\dots}{Additional arguments.}

\item{k}{A numeric value for the penalty per parameter. Default is 2, as in
classic AIC.}

\item{fxdDf}{A logical indicating whether to penalize according to the number
of fixed effect parameters. Since only models fit by REML can be compared,
these must always be the same and so become a constant. Hence, the default
is \code{FALSE}.}
}
\value{
A \code{numeric} value for either the log-likelihood and the number of
  parameters estimated by the model (sum of fixed effects and random effect
  (co)variance components) or Akaike's Information Criterion.
}
\description{
Extracts the log-likelihood or AIC from a gremlin model fit.
}
\examples{
mod11 <- gremlinR(WWG11 ~ sex - 1,
random = ~ calf,
data = Mrode11,
Gstart = matrix(0.1), Rstart = matrix(0.4),
maxit = 50, v = 2, algit = "EM")
logLik(mod11)
AIC(mod11)
}
\author{
\email{matthewwolak@gmail.com}
}
