% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableplot.R
\name{tableplot}
\alias{tableplot}
\title{Construct a plot for categorical variable}
\usage{
tableplot(x, y = NULL, labels = TRUE, legend = FALSE, points = TRUE, ...)
}
\arguments{
\item{x}{First categorical variable. Can be either vector, factor, matrix or a data
frame. If \code{y} is NULL and x is either matrix of a data frame, then the first two
variables of the data will be plotted against each other.}

\item{y}{Second categorical variable. If not provided, then only \code{x} will be
plotted.}

\item{labels}{Whether to print table labels inside the plot or not.}

\item{legend}{If \code{TRUE}, then the legend for the tableplot is drawn. The plot is
then produced on a separate canvas (new \code{par()}).}

\item{points}{Whether to plot points in the areas. They help in understanding how
many values lie in specific categories.}

\item{...}{Other parameters passed to the plot function.}
}
\value{
Function does not return anything. It just plots things.
}
\description{
Function constructs a plot for two categorical variables based on table function
}
\details{
The function produces the plot of the \code{table()} function with colour densities
corresponding to the respective frequencies of appearance. If the value appears more
often than the other (e.g. 0.5 vs 0.15), then it will be darker. The frequency of 0
corresponds to the white colour, the frequency of 1 corresponds to the black.

See details in the vignette "Marketing analytics with greybox":
\code{vignette("maUsingGreybox","greybox")}
}
\examples{

tableplot(mtcars$am, mtcars$gear)

}
\seealso{
\code{\link[graphics]{plot}, \link[base]{table}, \link[greybox]{spread}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{graph}
\keyword{plots}
