% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error-measures.R
\name{hm}
\alias{hm}
\alias{ham}
\alias{asymmetry}
\alias{extremity}
\title{Half moment of a distribution and its derivatives.}
\usage{
hm(x, C = mean(x), ...)

ham(x, C = mean(x), ...)

asymmetry(x, C = mean(x), ...)

extremity(x, C = mean(x), ...)
}
\arguments{
\item{x}{A variable based on which HM is estimated.}

\item{C}{Centring parameter.}

\item{...}{Other parameters passed to mean function.}
}
\value{
A complex variable is returned for \code{hm} function and real values
are returned for \code{asymmetry} and \code{ham}.
}
\description{
\code{hm} function estimates half moment from some predefined constant
\code{C}. \code{ham} estimates half absolute moment. Finally, \code{asymmetry}
function returns asymmetry coefficient, while \code{extremity}
returns the coefficient of excess, both based on \code{hm}.
}
\details{
\code{NA} values of \code{x} are excluded on the first step of calculation.
}
\examples{

x <- rnorm(100,0,1)
hm(x)
ham(x)
asymmetry(x)

}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
