% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern-array-gradient.R
\name{grid.pattern_gradient}
\alias{grid.pattern_gradient}
\title{Gradient patterned grobs}
\usage{
grid.pattern_gradient(
  x = c(0, 0, 1, 1),
  y = c(1, 0, 0, 1),
  id = 1L,
  ...,
  fill = gp$fill \%||\% "grey80",
  fill2 = "#4169E1",
  orientation = "vertical",
  alpha = gp$alpha \%||\% NA_real_,
  aspect_ratio = 1,
  key_scale_factor = 1,
  res = 72,
  default.units = "npc",
  name = NULL,
  gp = gpar(),
  draw = TRUE,
  vp = NULL
)
}
\arguments{
\item{x}{A numeric vector or unit object specifying x-locations of the pattern boundary.}

\item{y}{A numeric vector or unit object specifying y-locations of the pattern boundary.}

\item{id}{A numeric vector used to separate locations in x, y into multiple boundaries.
All locations within the same \code{id} belong to the same boundary.}

\item{...}{Currently ignored}

\item{fill}{Fill colour}

\item{fill2}{Second colour}

\item{orientation}{vertical, horizontal, or radial}

\item{alpha}{Alpha (between 0 and 1) or \code{NA} (default, preserves colors' alpha value).}

\item{aspect_ratio}{Override aspect ratio}

\item{key_scale_factor}{Additional scale factor for legend}

\item{res}{Assumed resolution (in pixels per graphic device inch) to use when creating array pattern.}

\item{default.units}{A string indicating the default units to use if \code{x} or \code{y}
are only given as numeric vectors.}

\item{name}{ A character identifier. }

\item{gp}{An object of class \code{"gpar"}, typically the output
    from a call to the function \code{\link[grid]{gpar}}.  This is basically
    a list of graphical parameter settings.}

\item{draw}{A logical value indicating whether graphics output
    should be produced.}

\item{vp}{A Grid viewport object (or NULL).}
}
\value{
A grid grob object invisibly.  If \code{draw} is \code{TRUE} then also draws to the graphic device as a side effect.
}
\description{
\code{grid.pattern_gradient()} draws a gradient pattern onto the graphic device.
}
\examples{
 x_hex <- 0.5 + 0.5 * cos(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
 y_hex <- 0.5 + 0.5 * sin(seq(2 * pi / 4, by = 2 * pi / 6, length.out = 6))
 grid.pattern_gradient(x_hex, y_hex, fill = "green")
 grid::grid.newpage()
 grid.pattern_gradient(x_hex, y_hex, fill = "green", orientation = "radial")
}
\seealso{
The \code{ggpattern} documentation: \url{https://coolbutuseless.github.io/package/ggpattern/articles/pattern-gradient.html}
}
