% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphaMaskGrob.R
\name{alphaMaskGrob}
\alias{alphaMaskGrob}
\title{Mask grob using another grob to specify the (alpha) mask}
\usage{
alphaMaskGrob(
  maskee,
  masker,
  use_R4.1_masks = getOption("ggpattern_use_R4.1_masks",
    getOption("ggpattern_use_R4.1_features")),
  png_device = NULL,
  res = getOption("ggpattern_res", 72),
  name = NULL,
  gp = gpar(),
  vp = NULL
)
}
\arguments{
\item{maskee}{Grob to be masked}

\item{masker}{Grob that defines masking region}

\item{use_R4.1_masks}{If \code{TRUE} use the grid mask feature introduced in R v4.1.0.
If \code{FALSE} do a \code{rasterGrob} approximation.
If \code{NULL} try to guess an appropriate choice.
Note not all graphic devices support the grid mask feature.}

\item{png_device}{\dQuote{png} graphics device to save intermediate raster data with if \code{use_R4.1_masks} is \code{FALSE}.
If \code{NULL} and suggested package \code{ragg} is available
and versions are high enough we directly capture masked raster via \code{\link[ragg:agg_capture]{ragg::agg_capture()}}.
Otherwise we will use \code{png_device}
(default \code{\link[ragg:agg_png]{ragg::agg_png()}} if available else \code{\link[grDevices:png]{grDevices::png()}}) and \code{\link[png:readPNG]{png::readPNG()}}
to manually compute a masked raster.}

\item{res}{Resolution of desired \code{rasterGrob} in pixels per inch if \code{use_R4.1_masks} is \code{FALSE}.}

\item{name}{ A character identifier. }

\item{gp}{An object of class \code{"gpar"}, typically the output
    from a call to the function \code{\link[grid]{gpar}}.  This is basically
    a list of graphical parameter settings.}

\item{vp}{A Grid viewport object (or NULL).}
}
\value{
A \code{grid} grob
}
\description{
\code{alphaMaskGrob()} masks a grob using another grob to specify the (alpha) mask.
}
\examples{
  if (capabilities("png") && require("grid")) {
    maskee <- patternGrob("circle", gp = gpar(col = "black", fill = "yellow"),
                           spacing = 0.1, density = 0.5)
    angle <- seq(2 * pi / 4, by = 2 * pi / 6, length.out = 7)
    x_hex_outer <- 0.5 + 0.5 * cos(angle)
    y_hex_outer <- 0.5 + 0.5 * sin(angle)
    x_hex_inner <- 0.5 + 0.25 * cos(rev(angle))
    y_hex_inner <- 0.5 + 0.25 * sin(rev(angle))
    gp <- gpar(lwd = 0, col = NA, fill = "white")
    masker <- grid::pathGrob(x = c(x_hex_outer, x_hex_inner),
                             y = c(y_hex_outer, y_hex_inner),
                             id = rep(1:2, each = 7),
                             rule = "evenodd", gp = gp)
    masked <- alphaMaskGrob(maskee, masker, use_R4.1_masks = FALSE)
    grid.newpage()
    grid.draw(masked)

    maskee_transparent <- rectGrob(gp = gpar(col = NA, fill = "blue"))
    gp <- gpar(lwd = 20, col = "black", fill = grDevices::rgb(0, 0, 0, 0.5))
    masker_transparent <- editGrob(masker, gp = gp)
    masked_transparent <- alphaMaskGrob(maskee_transparent,
                                        masker_transparent,
                                        use_R4.1_masks = FALSE)
    grid.newpage()
    grid.draw(masked_transparent)
  }
}
